<?php

class Kaskeluar extends CI_Controller{

	function __construct(){
		parent::__construct();
		if($this->session->userdata('isLogin') == FALSE) redirect('auth/login');
		$this->load->model('m_kaskeluar','kaskeluar');
	}


	public function index($id=null){
		 //$jml = $this->db->get('pasien');
		$get = $this->db->get('kas_keluar');

		$config['base_url'] = site_url().'/pasien/index';
		
		$config['total_rows'] = $get->num_rows();
		// $config['per_page'] = 10;
		// $config['next_page'] = '&raquo;';
		// $config['prev_page'] = '&laquo;';
		// $config['first_page'] = 'Awal';
		// $config['last_page'] = 'Akhir';

		$this->pagination->initialize($config);

        $data['query'] = $this->kaskeluar->tampil_kaskeluar($config['total_rows'],$id );
		$this->uri->segment(3);

		$data['halaman'] = $this->pagination->create_links();
		$this->load->view('head');
		$this->load->view('registrasi/kas_keluar_view', $data);
		$this->load->view('foot');
	}

	function search_keyword()
	{
		$keyword = $this->input->post('keyword');
		$data['query']  = $this->kaskeluar->search($keyword);
		$this->load->view('head');
		$this->load->view('registrasi/cari_kaskeluar',$data);
		$this->load->view('foot');
	}

	function cetak(){
		$data['cetak'] = $this->kaskeluar->cetak_kaskeluar();

		$this->load->view('registrasi/cetak_kaskeluar', $data);

	}


	function tambah(){
		if(isset($_POST['submit'])){

			$tgl = $this->input->post('tgl');
            $ket = $this->input->post('ket');
			$nominal = $this->input->post('nominal');

            $data = array(
            	'tgl'=>$tgl,
                'ket'=>$ket,
            	'nominal'=>$nominal,
            	'waktu'=>date('Y-m-d H:i:s')
            	);

            $this->kaskeluar->simpan_kaskeluar($data);
            $this->session->set_flashdata('pesan', '<div id="pesan" class="alert alert-success"><b>Sukses! </b> Data berhasil disimpan.</div>');
            redirect('kaskeluar');

        }else{
        	$this->load->view('head');
        	$this->load->view('registrasi/kaskeluar_tambah');
        	$this->load->view('foot');
        }
    }


    function ubah($id=null){
    	if(!$id){
    		echo 'Parameter Error. Hubungi Administrator Program.';
    	}else{
    		if(isset($_POST['submit'])){

    			$nama = $this->input->post('nama');
    			$umur = $this->input->post('umur');
                $jenis_kelamin = $this->input->post('jenis_kelamin');
    			$alamat = $this->input->post('alamat');
    			$telp = $this->input->post('telp');
    			//$riwayat = $this->input->post('riwayat');

                //disini upload file
            $this->load->library('upload'); //panggil libary upload

            $extension = pathinfo($_FILES['rm_upload']['name'], PATHINFO_EXTENSION);

            $namafile                = "file" .'_'.time().'.'.$extension; //nama file + fungsi time
            $config['upload_path']   = FCPATH.'assets/img/pasien/'; //Folder untuk menyimpan hasil upload
            $config['allowed_types'] = 'jpg|png|jpeg|bmp|pdf'; //type yang dapat diakses bisa anda sesuaikan
            $config['file_name']     = $namafile; //nama yang terupload nantinya

            $this->upload->initialize($config); //initialisasi upload dari array config
            $file_image_poto = $this->upload->data();

            $this->upload->do_upload('rm_upload');

    			$data = array(
    				'namalengkap'=>$nama,
                    'umur'=>$umur,
    				'jenis_kelamin'=>$jenis_kelamin,
    				'alamat'=>$alamat,
    				'telp'=>$telp,
    				'riwayat'=>$this->input->post('riwayat'),
                    'rm_upload'=>$file_image_poto['file_name']
    				);

    			$this->pasien->update_pasien($data, $id);
    			$this->session->set_flashdata('pesan', '<div id="pesan" class="alert alert-success"><b>Sukses! </b> Data berhasil diubah.</div>');
    			redirect('pasien');

    		}else{
    			$data['query'] = $this->pasien->ambil_pasien($id);

    			$this->load->view('head');
    			$this->load->view('pasien/pasien_edit', $data);
    			$this->load->view('foot');
    		}
    	}
    }


    function hapus($id=null){
    	if(!$id){
    		echo 'Parameter Error';
    	}else{
    		$data = array('tampil'=>0);

    		$this->kaskeluar->update_kaskeluar($data, $id);
    		$this->session->set_flashdata('pesan', '<div id="pesan" class="alert alert-success"><b>Sukses! </b> Data berhasil hapus.</div>');
    		redirect('kaskeluar');
    	}
    }


//end of class	
}