<?php

class Registrasi extends CI_Controller{

	function __construct(){
		parent::__construct();
		if($this->session->userdata('isLogin') == FALSE) redirect('auth/login');
		$this->load->model('m_registrasi','registrasi');
		$this->load->model('m_asuransi','asuransi');
		$this->load->model('m_pasien','pasien');
	}


	function index(){
		$data['query'] = $this->registrasi->tampil_registrasi();

		$this->load->view('head');
		$this->load->view('registrasi/reg_view', $data);
		$this->load->view('foot');
	}


	function daftar($id){

		if(!$id){
			echo 'Parameter Error';
		}else{
			if(isset($_POST['submit'])){

				$idreg = $this->input->post('idreg');
				$idpasien = $id;
				$keluhan = $this->input->post('keluhan');
				$tgl = date('Y-m-d');
				$divisi = $this->input->post('divisi');
				$kode_as = $this->input->post('kode_asuransi');
				$as = $this->asuransi->cari($kode_as);

				$data = array(
					'no_reg'=>preg_replace('/\D/', '', $idreg),
					'pasien_id'=>$idpasien,
					'tgl_reg'=>$tgl,
					'keluhan'=>$keluhan,
					'divisi'=>$divisi,
					'kode_asuransi'=>$kode_as,
					'nama_asuransi'=>$as->nama,
					'waktu'=>date('Y-m-d H:i:s')
				);

				$this->registrasi->simpan_data($data);
				$this->session->set_flashdata('pesan', '<div id="pesan" class="alert alert-success"><b>Sukses! </b> Pasien berhasil didaftarkan.</div>');
				redirect('registrasi');
			}else{
				$data['query'] = $this->pasien->ambil_pasien($id);
				$data['kode'] = $this->registrasi->kode();
				$data['asuransi'] = $this->asuransi->tampil();

				$this->load->view('head');
	    		$this->load->view('registrasi/reg_daftar', $data);
	    		$this->load->view('foot');
			}
		}
	}

	function hapus($id){
	    
		if(!$id){
    		echo 'Parameter Error';
    	}else{
    	    
			if($this->registrasi->cek_hapus($id)){
				$this->registrasi->hapus_reg($id);
				$this->session->set_flashdata('pesan', '<div id="pesan" class="alert alert-success"><b>Sukses! </b> Data berhasil hapus.</div>');
				redirect('registrasi');
			}else{
				$this->session->set_flashdata('pesan', '<div id="pesan" class="alert alert-warning"><b>Gagal! </b> Data terapi, tindakan atau diagnosa sudah dimasukkan.</div>');
				redirect('registrasi');

			}
    		
    	}
	}

//end of class
}	