<?php 

class M_registrasi extends CI_Model{

	function __construct(){
		parent::__construct();
	}

	function kode(){
		$this->db->select("RIGHT(no_reg,6) as kode", FALSE);
		$this->db->order_by('no_reg','DESC');
		$this->db->limit(1);

		$query = $this->db->get('registrasi');

		if($query->num_rows() <> 0){
			$data = $query->row();
			$kode = intval($data->kode) + 1;
		}else{
			$kode = 1;
		}


		$kodemax = str_pad($kode, 6, 0, STR_PAD_LEFT);
		$bln = date('m');
		$thn = date('Y');
		$kodejadi = "REG".$kodemax;

		return $kodejadi;
	}

	function simpan_data($data){
	    $query = $this->db->get_where('registrasi',array('pasien_id'=>$data['pasien_id']));
	    $data['st_pasien'] = ($query->num_rows() <= 0) ? "Baru" : "Lama";
		$this->db->insert('registrasi', $data);
	}

	function max_noreg(){
		$this->db->select_max('no_reg');
		$this->db->from('registrasi');
		$query=$this->db->get();
		return $query->result_array();
	}

	function tampil_registrasi(){
		$this->db->select('*, registrasi.id id_reg');
		$this->db->join('pasien','pasien.id = registrasi.pasien_id','left');
		$this->db->where('registrasi.status',0);
		$this->db->where('registrasi.tgl_reg',date('Y-m-d'));
		$this->db->where('registrasi.tampil',1);
		$this->db->order_by('registrasi.id','ASC');

		$query = $this->db->get('registrasi');

		return $query->result();
	}
	
	function cek_hapus($id){
		$query = $this->db->get_where('registrasi', array('id'=>$id, 'tampil'=>1));
		$mreg = $query->row();
		
		$this->db->from('diagnosa');
		$this->db->where('no_reg',$mreg->no_reg);
		$this->db->where('pasien_id',$mreg->pasien_id);		
		$this->db->where('tanggal_periksa',$mreg->tgl_reg);		
		$query=$this->db->get();
		$diag = $query->result_array();
		
		$this->db->from('terapi');
		$this->db->where('no_reg',$mreg->no_reg);
		$this->db->where('no_rm',$mreg->pasien_id);		
		$this->db->where('tgl',$mreg->tgl_reg);		
		$query=$this->db->get();
		$terapi = $query->result_array();
		
		$this->db->from('tindakan');
		$this->db->where('no_reg',$mreg->no_reg);
		$this->db->where('pasien_id',$mreg->pasien_id);		
		$this->db->where('tanggal_periksa',$mreg->tgl_reg);		
		$query=$this->db->get();
		$tind = $query->result_array();
		
		if(count($diag)>0 && count($terapi)>0 && count($tind)>0){
			return false;
		}else{
			return true;
		}
	}
	
	function hapus_reg($id){
		$this->db->where('id', $id);
		$this->db->limit(1);
		$this->db->update('registrasi', array('tampil'=>0) );
	}

//end of class
}	